% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluidigmAnalysisWrapper.R
\name{fluidigmAnalysisWrapper}
\alias{fluidigmAnalysisWrapper}
\title{Run the Fluidigm Analysis Script Together}
\usage{
fluidigmAnalysisWrapper(
  file,
  out = NA,
  outdir = NA,
  db = NA,
  appendSamplesToDB = FALSE,
  map = NA,
  keep.rep = 1,
  neg_controls = NA,
  y.marker = NA,
  x.marker = NA,
  sp.marker = NA,
  plots = TRUE,
  allele_error = 5,
  marker_dropout = 15,
  no_marker = 50,
  male.y = 3,
  male.hetX = 0,
  female.y = 0,
  female.Xtot = 8,
  female.hetXtot = 3,
  warning.noYtot = 2,
  warning.noHetXtot = 3,
  rearrange = TRUE,
  group = NA,
  fixNames = TRUE,
  sexing = TRUE,
  similarity = 0.85,
  verbose = TRUE,
  verbosity = 1,
  missing.geno = "0 0",
  overwrite = FALSE
)
}
\arguments{
\item{file}{A string specifying the path to the Fluidigm input file.}

\item{out}{A string specifying the output file name. If left empty, the original basename of the input file will be used.}

\item{outdir}{A string specifying the output folder. If left empty the original folder path of the input file will be used.}

\item{db}{A string specifying the filepath to the database file. If not provided, the function will proceed with the existing data.}

\item{appendSamplesToDB}{A logical indicating whether new samples should be added to the database. Default is FALSE.}

\item{map}{A string specifying the filepath to the PlateDnoY.map file. If not provided, the function will use the map file with the same name as the ped file.}

\item{keep.rep}{A numeric value indicating the number of replicates to keep. Default is 1.}

\item{neg_controls}{A vector specifying the names of negative controls. Default is NA.}

\item{y.marker}{A vector specifying the Y markers for sexing. Default is NA.}

\item{x.marker}{A vector specifying the X markers for sexing. Default is NA.}

\item{sp.marker}{A vector specifying the markers used for species identification. Default is NA.}

\item{plots}{A logical indicating whether plots should be created. Default is TRUE.}

\item{allele_error}{A numeric value specifying the threshold for RERUN on Allele errors. Default is 5.}

\item{marker_dropout}{A numeric value specifying the threshold for RERUN on Marker dropout. Default is 15.}

\item{no_marker}{A numeric value specifying the number of markers. Default is 50.}

\item{male.y}{A numeric value specifying the threshold for sexing, male y-chromosome markers. Default is 3.}

\item{male.hetX}{A numeric value specifying the threshold for sexing, heterozygote x-chr markers. Default is 0.}

\item{female.y}{A numeric value specifying the threshold for sexing, female y-chromosome markers. Default is 0.}

\item{female.Xtot}{A numeric value specifying the threshold for sexing, total female x-chr markers. Default is 8.}

\item{female.hetXtot}{A numeric value specifying the threshold for sexing, heterozygote x-chr markers. Default is 3.}

\item{warning.noYtot}{A numeric value specifying the threshold for sexing, when should warning be triggered. Default is 2.}

\item{warning.noHetXtot}{A numeric value specifying the threshold for sexing, when should warning be triggered. Default is 3.}

\item{rearrange}{A logical indicating whether the ped/map output should be rearranged in order of provided map file. Default is TRUE.}

\item{group}{A string specifying the sample identifier for statistics. Default is NA.}

\item{fixNames}{A logical indicating whether whitespaces from sample names should be automatically removed. Default is TRUE.}

\item{sexing}{A logical indicating whether sexing should be performed. Default is FALSE.}

\item{similarity}{Similarity threshold. Default: 0.85.}

\item{verbose}{A logical or numerical value indicating whether the output should be verbose. Default is TRUE.}

\item{verbosity}{A numerical value indicating the level of verbosity. Set to a higher number for more details. Default is 1.}

\item{missing.geno}{A character string specifying how missing values should be coded. Default is "0 0".}

\item{overwrite}{A logical indicating wheter the original map file should be overwritten or not. Default FALSE}
}
\value{
A list containing the following elements:
gensim, a matrix indicating if genotypes are called correctly for replicates and/or if genotypes are missing
summs, a matrix with summary statistics
}
\description{
This function serves as a wrapper for the entire analysis pipeline. It takes a Fluidigm input file and performs several operations including conversion to 'PLINK' format, error estimation, calculation of pairwise similarities, determination of pairwise similarity loci, and calculation of the similarity matrix.
}
\details{
The function first checks the input parameters and sets default values if necessary. It then runs the following functions in order:
\itemize{
\item fluidigm2PLINK: Converts the Fluidigm data to PLINK format.
\item estimateErrors: Estimates errors in the PLINK ped files.
\item calculatePairwiseSimilarities: Calculates pairwise similarities between genotypes.
\item getPairwiseSimilarityLoci: Determines the loci of pairwise similarities.
\item similarityMatrix: Calculates the similarity matrix.
The function prints a completion message when all operations are done.
}
}
\examples{
\dontrun{
  fluidigmAnalysisWrapper(file="path/to/your/file.csv", map="path/to/your/mapfile.map")
}

}
\references{
\itemize{
\item{Purcell S, Neale B, Todd-Brown K, Thomas L, Ferreira MAR, Bender D, Maller J, Sklar P, de Bakker PIW, Daly MJ & Sham PC (2007)
\emph{PLINK: a toolset for whole-genome association and population-based linkage analysis.} American Journal of Human Genetics, 81.}
\item{Purcell, Shaun. PLINK. \url{https://zzz.bwh.harvard.edu/plink/}}}
}
\seealso{
\itemize{
\item{\code{\link{fluidigm2PLINK}}: Converts the Fluidigm data to PLINK format.}
\item{\code{\link{estimateErrors}}: Estimates errors in the PLINK ped files.}
\item{\code{\link{calculatePairwiseSimilarities}}: Calculates pairwise similarities between genotypes.}
\item{\code{\link{getPairwiseSimilarityLoci}}: Determines the loci of pairwise similarities.}
\item{\code{\link{similarityMatrix}}: Calculates the similarity matrix.}
}
}
