% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fishPhyloMaker.R
\name{FishPhyloMaker}
\alias{FishPhyloMaker}
\title{Obtaining fish phylogeny according to a local pool of species}
\usage{
FishPhyloMaker(
  data,
  insert.base.node = FALSE,
  return.insertions = TRUE,
  progress.bar = TRUE
)
}
\arguments{
\item{data}{A data frame with three columns containing the name of species (s), the Family (f) and the Order (o). This data frame can be generated
with tab_function function.}

\item{insert.base.node}{Logical argument indicating if the species must be added automatically
in the family and order (when needed) nodes. Default is FALSE}

\item{return.insertions}{Logical, if TRUE (default) the output is a list of length two containing the phylogeny
and a dataframe with a column indicating at which level each species was inserted.}

\item{progress.bar}{Logical argument. If TRUE (default) a progress bar will be shown in console.}
}
\value{
A newick object containing the phylogeny with the species in data object. If return.insertions = TRUE the output
will be a list of length two containing the newick phylogeny and a data frame equal that provided in data plus a column
indicating at which level each species was inserted in the tree.
}
\description{
Obtaining fish phylogeny according to a local pool of species
}
\examples{
\donttest{
    data("taxon_data_PhyloMaker")
    res_phylo <- FishPhyloMaker(data = taxon_data_PhyloMaker,
    insert.base.node = TRUE, 
    return.insertions = TRUE, 
    progress.bar = TRUE)
}
    

}
