% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.quad.plateau.R
\name{f.quad.plateau}
\alias{f.quad.plateau}
\title{Fitting quadratic plateau model using multiple initial values}
\usage{
f.quad.plateau(
  d,
  start = list(a = 1, b = 1, c = 1),
  plus_minus = 100,
  n.start = 1000,
  msg = FALSE
)
}
\arguments{
\item{d}{data frame with two columns (\code{x} and \code{y})}

\item{start}{initial estimate for non-linear least square (default value: \code{ list(a = 1, b = 1, c = 1)})}

\item{plus_minus}{radius of random initial values (default: \code{100})}

\item{n.start}{total number of initial points considered (default: \code{1000})}

\item{msg}{logical flag whether printing progress}
}
\value{
\code{f.quad.plateau} returns a list of two components (if converged): \code{nls.summary}: summary of the fitted model; \code{nls.model}: nls object
}
\description{
\code{f.quad.plateau} fits quadratic plateau model using multiple initial values. The multiple initial values are randomly sampled in  a "cube" of parameter space. More precisely, quadratic plateau model assumes
    y ~ (a + b * x + c *x^2) * (x <= -0.5*b/c) + (a + -b^2/(4 * c)) * (x > -0.5 * b/c).
}
\examples{

set.seed(3)
x <- rep(1:300, each=4)
a <- 8; b <- 0.05; c <- -1e-4
y <- (a + b * x + c *x^2) * (x <= -0.5*b/c) + (a + -b^2/(4 * c)) * (x > -0.5 * b/c) +
    rnorm(length(x), sd=0.1)
d <- cbind(x,y)

# a converged example:
ans <- f.quad.plateau(d, start=list(a = 7, b = 0.02, c = 1e-5),
    plus_minus=10, n.start=10, msg=FALSE)

summary(ans$nls.model)



}
