\name{plot.simfam_tvc}
\alias{plot.simfam_tvc}
\title{Plot method for \code{simfam_tvc} or Plot pedigrees}
\description{
Provides pedigree plots for specified families generated from \code{simfam_tvc} function with option to save plots into a pdf file.
}
\usage{
\method{plot}{simfam_tvc}(x, famid, pdf = FALSE, file = NULL, \ldots)
}
\arguments{
 \item{x}{An object of class \code{'simfam_tvc'} created by \code{\link{simfam_tvc}} function or a data frame that has class attributes \code{c("simfam_tvc", "data.frame")}.
}
 \item{famid}{List of family IDs to plot. Default is the first family in given data set.}
 \item{pdf}{Logical; if \code{TRUE}, pedigree plots are saved in a pdf file. If \code{FALSE}, plot pedigrees on current plotting device. Default is \code{FALSE}.}
 \item{file}{File name to save the pedigree plots; Default file name is \code{"pedigreeplot.pdf"}.}
 \item{...}{Additional arguments passed on to the plot function.}
 
}

\details{
Argument \code{x} can be a data frame that contains \code{famID}, \code{indID}, \code{fatherID},  \code{motherID}, \code{gender} (1 for male, 0 for female), \code{status} (1 for affected, 0 for non-affected), \code{mgene} (1 for mutation carrier, 0 for non-carrier, \code{NA} for missing), and \code{proband} (1 for proband, 0 for non-proband) and should have class attributes \code{class(x) <- c("simfam", "data.frame")}.

Optionally, the data frame can contain a column named \code{carrp.geno} or \code{carrp.pheno} to replace missing values in \code{mgene} with their carrier probabilities.
}

\value{
Returns pedigree plots for specified families created by \code{\link{simfam_tvc}} function or for the data frame provided along with the affection and carrier mutation statuses of family members. Probands from each pedigree are indicated using red color.

When object inlcudes \code{carrp.geno} and/or \code{carrp.pheno} generated by \code{\link{carrierprob}} function, the \code{plot} function displays the carrier probabilities for those with missing carrier status.
}


\seealso{
\code{\link{simfam_tvc}, \link{summary.simfam_tvc}, \link{carrierprob}}	
}

\examples{

# Simulated family data
set.seed(4321)
fam <- simfam_tvc(N.fam = 10, design = "pop", variation = "frailty", 
       base.dist = "Weibull", frailty.dist = "gamma", depend = 1, 
       add.tvc = TRUE, tvc.type = "CO", tvc.range = c(30,60), 
       tvc.parms = c(1, 0.1, 0), allelefreq = 0.02, 
       base.parms = c(0.01, 3), vbeta = c(-1.13, 2.35))
 
# Pedigree plots for first three simulated families

plot(fam, famid = c(1:2))

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Pedigree plot }
