% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qselection.R
\name{qselection}
\alias{qselection}
\title{Selecting variables for several subset sizes}
\usage{
qselection(x, y, qvector, criterion = "deviance", method = "lm",
  family = "gaussian", nfolds = 5, cluster = TRUE, ncores = NULL)
}
\arguments{
\item{x}{A data frame containing all the covariates.}

\item{y}{A vector with the response values.}

\item{qvector}{A vector with more than one variable-subset size to be
selected.}

\item{criterion}{The information criterion to be used.
Default is the deviance. Other functions provided
are the coefficient of determination (\code{"R2"}), the residual
variance (\code{"variance"}), the Akaike information criterion (\code{"aic"}),
AIC with a correction for finite sample sizes (\code{"aicc"})
and the Bayesian information criterion (\code{"bic"}). The deviance,
coefficient of determination and variance are calculated by cross-validation.}

\item{method}{A character string specifying which regression method is used,
i.e., linear models (\code{"lm"}), generalized additive models
(\code{"glm"}) or generalized additive models (\code{"gam"}).}

\item{family}{A description of the error distribution and link function to be
used in the model: (\code{"gaussian"}), (\code{"binomial"}) or
(\code{"poisson"}).}

\item{nfolds}{Number of folds for the cross-validation procedure, for
\code{deviance}, \code{R2} or \code{variance} criterion.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
procedure is  parallelized. Note that there are cases without enough
repetitions (e.g., a low number of initial variables) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores to be used
is equal to the number of cores of the machine - 1.}
}
\value{
\item{q}{A vector of subset sizes.}
\item{criterion}{A vector of Information criterion values.}
\item{selection}{Selected variables for each size.}
}
\description{
Function that enables to obtain the best variables for more than
 one size of subset. Returns a table with the chosen covariates to be
 introduced into the models and their information criteria. Additionally, an
  asterisk is shown next to the size of subset which minimizes the
  information criterion.
}
\examples{
library(FWDselect)
data(diabetes)
x = diabetes[ ,2:11]
y = diabetes[ ,1]
obj2 = qselection(x, y, qvector = c(1:9), method = "lm", criterion = "variance", cluster = FALSE)
obj2

}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\seealso{
\code{\link{selection}} \code{\link{plot.qselection}}.
}

