% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_assessment.R
\name{make_sq_inter}
\alias{make_sq_inter}
\title{Squares and two-way interactions of variables}
\usage{
make_sq_inter(
  data_frame,
  is_square = TRUE,
  is_inter = TRUE,
  keep_marginal = TRUE
)
}
\arguments{
\item{data_frame}{Data frame containing the variables whose squares and interactions are to be created.}

\item{is_square}{If \code{TRUE}, square of each column of \code{data_frame} is created.}

\item{is_inter}{If \code{TRUE}, product of every pair of columns of \code{data_frame} is created.}

\item{keep_marginal}{If \code{TRUE}, the original columns of \code{data_frame} are retained 
in the resulting data frame.}
}
\value{
A data frame containing the squares and/or pairwise products of \code{data_frame}.
}
\description{
Generates squares and/or two-way interactions (pairwise products) of the columns of a data frame.
}
\examples{
# Consider a data frame with N = 12 units and 2 covariates.
data_frame_sample = data.frame(male = c(rep(1,6),rep(0,6)), 
age = c(20,30,40,40,50,60,20,30,40,40,50,60))
# Get a data frame with all possible squares and first order interactions.
make_sq_inter(data_frame = data_frame_sample, is_square = TRUE, 
is_inter = TRUE, keep_marginal = FALSE)
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
