% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conventional_designs.R
\name{crd}
\alias{crd}
\title{Completely Randomized Design (CRD)}
\usage{
crd(data_frame, n_treat, treat_sizes, control = FALSE)
}
\arguments{
\item{data_frame}{A data frame corresponding to the full sample of units.}

\item{n_treat}{Number of treatment groups.}

\item{treat_sizes}{A vector of treatment group sizes. If \code{control = TRUE}, 
the first element of \code{treat_sizes} should be the control group size.}

\item{control}{If \code{TRUE}, treatments are labeled as 0,1,...,g-1 (0 representing the control group). 
If \code{FALSE}, they are labeled as 1,2,...,g.}
}
\value{
The original data frame augmented with the column of the treatment indicator.
}
\description{
Generates an assignment under completely randomized design (CRD).
}
\examples{
# Consider N = 12, n1 = n2 = n3 = 4.
df_sample = data.frame(index = 1:12, x = c(20,30,40,40,50,60,20,30,40,40,50,60))
# Draw a random assignment from CRD.
fc = crd(data_frame = df_sample, n_treat = 3, treat_sizes = c(4,4,4))
# Get vector of treatment assignments.
Z_crd = fc$Treat
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), 
``Randomized and Balanced Allocation of Units into Treatment Groups Using the Finite Selection Model for \code{R}''.
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
