
#include<RcppArmadillo.h>

// [[Rcpp::export(rng = false)]]
Rcpp::List indicesAboveDiag(const int K)
{
    Rcpp::List idx(((K - 1) * K) / 2);

    int k = 0;
    for (int i = 1; i <= K; ++i)
    {
        for (int j = i + 1; j <= K; ++j)
        {
            idx[k] = Rcpp::IntegerVector::create(i, j);
            k++;
        }
    }

    return idx;
}

// [[Rcpp::export(rng = false)]]
Rcpp::NumericMatrix onewayMatrix(const int K)
{
    Rcpp::NumericMatrix mat((K * (K - 1)) / 2, K);
    int k = 0;
    for (int i = 0; i < K; ++i)
    {
        for (int j = i + 1; j < K; ++j)
        {
            mat(k, i) = 1.0;
            mat(k, j) = -1.0;
            k++;
        }
    }
    return mat;
}

// [[Rcpp::export(rng = false)]]
Rcpp::List indicesAll(const int K1, const int K2)
{
    Rcpp::List idx(K1 * K2);

    int k = 0;
    for (int i = 1; i <= K1; ++i)
    {
        for (int j = 1; j <= K2; ++j)
        {
            idx[k] = Rcpp::IntegerVector::create(i, j);
            k++;
        }
    }

    return idx;
}
