% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulo_method.R
\name{modulo_method}
\alias{modulo_method}
\title{Modulo Method - Described by Street et al.}
\usage{
modulo_method(fractional_fatorial, generators)
}
\arguments{
\item{fractional_fatorial}{The usual.}

\item{generators}{a list of generators}
}
\value{
a choiceset list.
}
\description{
Modulo Method - Described by Street et al.
}
\examples{
# See step 6 of the Practical Introduction to ExpertChoice vignette.

# Step 1
attrshort  = list(condition = c("0", "1", "2"),
technical =c("0", "1", "2"),
provenance = c("0", "1"))

#Step 2
# ff stands for "full fatorial"
 ff  <-  full_factorial(attrshort)
 af  <-  augment_levels(ff)
# af stands for "augmented factorial"

# Step 3
# Choose a design type: Federov or Orthogonal. Here an Orthogonal one is used.
nlevels <- unlist(purrr::map(ff, function(x){length(levels(x))}))
fractional_factorial <- DoE.base::oa.design(nlevels = nlevels, columns = "min34")

# Step 4
# The functional draws out the rows from the original augmented full factorial design.
colnames(fractional_factorial) <- colnames(ff)
fractional <- search_design(ff, fractional_factorial)
# Step 5 - Skipped, but important, see vignette.

# Step 6! -- The modulo_method function
# Two modulators c(1,1,1) and c(0,1,1) are specified.
dce_modulo <- modulo_method(
fractional,
list(c(1,1,1),c(0,1,1))
)
dce_modulo
}
