% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyDEseq.R
\name{polyDESeq}
\alias{polyDESeq}
\title{Make a Triangle Diagram}
\usage{
polyDESeq(
  P1_count,
  P2_count,
  F1_count,
  P1_name,
  P2_name,
  F1_name,
  type,
  homoeologs,
  count_threshold = 5,
  Pvalue = 0.05
)
}
\arguments{
\item{P1_count}{A data frame. The count table of genes in P1 species. For the count table, the first column is the gene identifier, and other columns are the read counts of the genes in each biological replicate.}

\item{P2_count}{A data frame. The count table of genes in P2 species.}

\item{F1_count}{A data frame. The count table of genes in F1 species.}

\item{P1_name}{A character. Category names of P1 species.}

\item{P2_name}{A character. Category names of P2 species.}

\item{F1_name}{A character. Category names of F1 species.}

\item{type}{A character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes in the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{count_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 5 (the count values in all replicates).}

\item{Pvalue}{A numeric. Threshold for significance test in differential expression analysis. Default is 0.05.}
}
\value{
Triangle Diagram
}
\description{
The count matrix of different species as the input data to perform differential expression analysis using DESeq2. And the number of differentially expressed genes between any two species is marked on the triangle diagram.
}
\details{
The 'homoeologs' table contains the orthologs pairs. In detail, the first column is the group name (unique) of homoeologs among three species (Parents: P1;P2, Progeny: F1), the second column is the Gene ID of P1, the third column is the Gene ID of P2. And the fourth column and fifth columns are the identifier of F1 orthologs derived from P1 and P2 ancestors, respectively (e.g. "Homoeolog1	BraA01t00004Z	BolC01g000040.2J BnA01g0000030.1 BnC01g0424620.1").
}
\examples{
\donttest{
polyDESeq(P1_count = P1_miRNA_count,
          P2_count = P2_miRNA_count,
          F1_count = F1_miRNA_count,
          P1_name = "B.napus(AACC)",
          P2_name = "B.rapa(AA)",
          F1_name = "B.napus x B.rapa (AAAACC)",type="sRNA")
}
}
