% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat2.ad2.dic.r
\name{fat2.ad2.dic}
\alias{fat2.ad2.dic}
\title{Fatorial duplo em DIC com dois tratamentos adicionais}
\usage{
fat2.ad2.dic(
  fator1,
  fator2,
  repet,
  resp,
  respAd1,
  respAd2,
  quali = c(TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2"),
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{fator1}{Vetor numerico ou complexo contendo os niveis
do fator 1.}

\item{fator2}{Vetor numerico ou complexo contendo os niveis
do fator 2.}

\item{repet}{Vetor numerico ou complexo contendo as
repeticoes.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{respAd1}{Vetor numerico ou complexo contendo a variavel
resposta do tratamento adicional 1.}

\item{respAd2}{Vetor numerico ou complexo contendo a variavel
resposta do tratamento adicional 2.}

\item{quali}{Logico, se TRUE (default) na primeira posicao,
os niveis do fator 1 sao entendidos como qualitativos, se
FALSE, quantitativos; da mesma forma, a segunda posicao e
referente aos niveis do fator 2.}

\item{mcomp}{Permite escolher o teste de comparacao multipla;
o \emph{default} e o teste de Tukey, contudo tem-se como
outras opcoes: o teste LSD ('lsd'), o teste LSDB ('lsdb'),
o teste de Duncan ('duncan'), o teste de SNK ('snk'), o
teste de Scott-Knott ('sk'), o teste de comparacoes
multiplas bootstrap ('ccboot') e o teste de Calinski e
Corsten baseado na distribuicao F ('ccf').}

\item{fac.names}{Permite nomear os fatores 1 e 2.}

\item{sigT}{Significancia a ser adotada pelo teste de
comparacao multipla de medias; o default e 5\%.}

\item{sigF}{Significancia a ser adotada pelo teste F da
ANAVA; o default e 5\%.}

\item{unfold}{Orienta os desdobramentos apos a analise de
variancia. Se NULL (\emph{default}), sao feitas as analises
recomendadas; se '0', e feita apenas a analise de variancia;
se '1', os efeitos simples sao estudados; se '2', a interacao
dupla e estudada.}
}
\value{
Sao retornados os valores da analise de variancia
do DBC em questao com um tratamento adicional,o teste de
normalidade de Shapiro-Wilk para os residuos do modelo, o
ajuste de modelos de regressao (caso de tratamentos
quantitativos) ou os testes de comparacao de medias (caso de
tratamentos qualitativos): teste de Tukey, teste de Duncan,
teste t de Student (LSD), teste t de Bonferroni, teste de
Student-Newman-Keuls (SNK), teste de Scott-Knott e teste de
comparacoes multiplas bootstrap; com o desdobramento da
interacao, caso esta seja significativa.
}
\description{
\code{fat2.ad2.dic} Analisa experimentos em fatorial duplo
com dois tratamentos adicionais em Delineamento Inteiramente
Casualizado, considerando o modelo fixo.
}
\details{
Os argumentos sigT e mcomp so serao utilizados
quando os tratamentos forem qualitativos.
}
\note{
O \code{\link{graficos}} pode ser usado para
construir os graficos da regressao e o
\code{\link{plotres}} para analise do residuo da anava.
}
\examples{
fator1<-c(rep(1,6),rep(2,6))
fator2<-c(rep(1,3),rep(2,3),rep(1,3),rep(2,3))
repet<-rep(1:3,4)
resp<-c(10.0,10.8,9.8,10.3,11.3,10.3,9.7,10.1,10.2,9.4,11.6,9.1)
respAd1<-c(10.6,10.6,10.4)
respAd2<-c(5.7,6,7.4)
data.frame(fator1,fator2,repet,resp)
fat2.ad2.dic(fator1, fator2, repet, resp, respAd1, respAd2,
quali=c(TRUE, FALSE), mcomp = "tukey", fac.names =
c("XXXX", "YYYY"), sigT = 0.05, sigF = 0.05, unfold=NULL)
}
\references{
???
}
\seealso{
\code{\link{fat2.dic}}, \code{\link{fat2.dbc}},
\code{\link{fat3.dic}}, \code{\link{fat3.dbc}},
\code{\link{fat2.ad.dic}}, \code{\link{fat2.ad.dbc}},
\code{\link{fat3.ad.dic}} and \code{\link{fat3.ad.dbc}}.
}
\author{
Portya Piscitelli Cavalcanti

Sônia Maria De Stefano Piedade

Eric B Ferreira,
\email{eric.ferreira@unifal-mg.edu.br}
}
