% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envfas.R
\name{envfascpp}
\alias{envfascpp}
\title{Convert Fasta Files into Environment Vectors}
\usage{
envfascpp(path, r = 10, exefile, outfile)
}
\arguments{
\item{path}{path to the folder that contain a the file 'list.txt', which contains the names of all the fasta files to be analyzed (one per line). The fasta files must be in the same path.}

\item{r}{a positive integer indicating the radius of the sequence segment considered as environment.}

\item{exefile}{path to the directory containing the envfas executable.}

\item{outfile}{path to, and name of, output file.}
}
\value{
A txt file per fasta file analyzed. Each txt file can be read as a vector. Thus the number of lines gives the dimension of the vector.
}
\description{
Converts fasta files into environment vectors
}
\details{
This function builds and write vectors representing the species' proteome. To use this function, you must first download the source code envfas.cpp (https://bitbucket.org/jcaledo/envnj/src/master/AncillaryCode/envfas.cpp) and compile it.
}
\examples{
\dontrun{envfastacpp("./data_t/list.txt", 10, ".", "./MyResults")}
}
\seealso{
envnj(), fastaconc()
}
