% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_encompass_dnorm.R
\name{pred_encompass_dnorm}
\alias{pred_encompass_dnorm}
\title{Direct Multi-Step Forecast Based Comparison of Nested Models via an Encompassing Test}
\usage{
pred_encompass_dnorm(e1hat, e2hat, mu0)
}
\arguments{
\item{e1hat}{a vector of out of sample forecast errors from model 1 (smaller model)}

\item{e2hat}{a vector of out of sample forecast errors from model 2 (larger model)}

\item{mu0}{Fraction of the sample, which should be within 0 and 1 (0.5 should be avoid)}
}
\value{
A list of normalised d statistics and corresponding P values will be produced.
}
\description{
It calculates the dbar statistics for nested models with null hypothesis being the larger
model failing to add any useful information to the small model following Pitarakis (2023).
There are in total six versions of dbar, based on the assumptions of variance (homo or hete)
and residuals (original, adjusted based on NW, or adjusted based on Andrews).
All dbar statistics will be standarised to a standard N(0,1) normal distribution,
and corresponding P values would be provided.
}
\examples{
e1<- rnorm(15);
e2<- rnorm(15);
temp1 <- pred_encompass_dnorm(e1,e2,mu0=0.2)
temp1$T1_d_alrv     #normalised d statistics with Andrews quadratic kernel long-run variance
temp1$Pval_T1_d_alrv  #P value of it
}
\references{
Pitarakis, J. Y. (2023). Direct Multi-Step Forecast based Comparison of Nested Models via an Encompassing Test. arXiv preprint arXiv:2312.16099.
}
