% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elochoice.R
\name{elochoice}
\alias{elochoice}
\alias{eloint}
\alias{elointnorm}
\title{Elo-ratings for pairwise comparisons of visual stimuli}
\usage{
elochoice(winner, loser, kval = 100, startvalue = 0, runs = 1, normprob = FALSE)
eloint(winner, loser, allids, kval, startvalues, runs)
elointnorm(winner, loser, allids, kval, startvalues, runs)
}
\arguments{
\item{winner}{character, vector with the IDs of the winning (preferred) and losing (not preferred) stimuli}

\item{loser}{character, vector with the IDs of the winning (preferred) and losing (not preferred) stimuli}

\item{kval}{numeric, k-value, which determines the maximum number of points a stimulus' rating can change after a single rating event, by default 100}

\item{startvalue}{numeric, start value around which ratings are centered, by default 0}

\item{runs}{numeric, number of randomizations}

\item{normprob}{logical, by default \code{FALSE}, which indicates that a logistic approach is taken for calculating winning probabilities (see Elo 1978). Alternatively (\code{TRUE}), such that winning probabilities are calculated from a normal distribution}

\item{startvalues}{numeric, start value around which ratings are centered, by default 0}

\item{allids}{internal, character of all stimulus IDs in the data set}
}
\value{
an object of class \code{elochoice}, i.e. a list with the following items
  \item{ratmat}{numeric matrix with final ratings for each stimulus, one row per randomization}
  \item{decmat}{logical matrix showing for each randomization (row) and each single rating event (column) whether or not there was an expectation for that trial, i.e. whether the two stimuli's ratings differed before the rating}
  \item{upsmat}{logical matrix showing for each randomization (row) and each single rating event (column) whether or not the outcome of a trial was in the direction of the expectation, i.e. whether or not the higher rated stimulus won}
  \item{wgtmat}{numeric matrix showing for each randomization (row) and each single rating event (column) the absolute difference in ratings before the rating event}
  \item{misc}{various information}
  \item{ov}{data set overview, i.e. in how many trials was a stimulus involved and how many trials did each stimulus win and lose}
  \item{ias}{character matrix, with the original sequence of rating events}
}
\description{
Elo-ratings for pairwise comparisons of visual stimuli
}
\details{
\code{elochoice()} is the workhorse function of the package, which wraps up all the calculations for obtaining Elo-ratings and the information for the reliability index

\code{eloint()} and \code{elointnorm()} are internal functions (which \code{elochoice()} makes use of) that do most of the calculations, but are usually not directly addressed by the user.
}
\examples{
data(physical)
set.seed(123)
res <- elochoice(winner = physical$Winner, loser = physical$Loser, runs = 100)
summary(res)
ratings(res, show = NULL, drawplot = TRUE)
}
\references{
\insertRef{elo1978}{EloChoice}

\insertRef{clark2018}{EloChoice}
}
\author{
Christof Neumann
}
