% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co_occurrence.r
\name{co_occurrence}
\alias{co_occurrence}
\title{Compute the number of co-occurrences between industry pairs from an incidence (industry - event) matrix}
\usage{
co_occurrence(mat, diagonal = FALSE, list = FALSE)
}
\arguments{
\item{mat}{An incidence matrix with industries in rows and events in columns}

\item{diagonal}{Logical; shall the values in the diagonal of the co-occurrence matrix be included in the output? Defaults to FALSE (values in the diagonal are set to 0), but can be set to TRUE (values in the diagonal reflects in how many events a single industry can be found)}

\item{list}{Logical; is the input a list? Defaults to FALSE (input = adjacency matrix), but can be set to TRUE if the input is an edge list}
}
\value{
The co-occurrence matrix as an R matrix object.
}
\description{
This function computes the number of co-occurrences between industry pairs from an incidence (industry - event) matrix
}
\examples{
## generate a region - events matrix
set.seed(31)
mat <- matrix(sample(0:1, 20, replace = TRUE), ncol = 5)
rownames(mat) <- c("I1", "I2", "I3", "I4")
colnames(mat) <- c("US1", "US2", "US3", "US4", "US5")

## run the function
co_occurrence(mat)
co_occurrence(mat, diagonal = TRUE)

## generate a regular data frame (list)
my_list <- get_list(mat)

## run the function
co_occurrence(my_list, list = TRUE)
co_occurrence(my_list, list = TRUE, diagonal = TRUE)
}
\references{
Boschma, R., Balland, P.A. and Kogler, D. (2015) Relatedness and Technological Change in Cities: The rise and fall of technological knowledge in U.S. metropolitan areas from 1981 to 2010, \emph{Industrial and Corporate Change} \strong{24} (1): 223-250
}
\seealso{
\code{\link{relatedness}}, \code{\link{relatedness_density}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{relatedness}
