\name{productionEfficiency}
\alias{prod_eff}
\title{Production efficiency}
\usage{
prod_eff(Grain_yield, Total_duration_of_the_crop)
}
\arguments{
\item{Grain_yield}{Grain yield (kg/ha)}
\item{Total_duration_of_the_crop}{Total duration of the crop (in days)}
}
\value{
Production efficiency (kg/ha/day)
}
\description{
Production efficiency refers to the ability of a production system to convert inputs (such as labor, materials, and capital) into outputs (goods or services) in the most efficient manner without wasting resources.
}
\examples{
Grain_yield <- 8.67
Total_duration_of_the_crop <- 270
prod_eff(Grain_yield, Total_duration_of_the_crop)
}
\references{
Kumar, M., Rajkhowa, D.J., Meena, K.L., Rakesh, K., Zeliang, P.K., Kikon, E.L., Rangnamei, K.L., Namei, A., 2017. Effect of nutrient management in lowland rice for improving productivity, profitability and energetics under the mid hill of Nagaland. J. AgriSearch 4, 247–250.\\
Dutta, S. K., Layek, J., Yadav, A., Das, S. K., Rymbai, H., Mandal, S. & Mishra, V. K. (2023). Improvement of rooting and growth in kiwifruit (Actinidia deliciosa) cuttings with organic biostimulants. Heliyon, 9(7).
}
\keyword{Production efficiency}

