% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eztune_cv.R
\name{eztune_cv}
\alias{eztune_cv}
\title{Cross Validated Accuracy for Supervised Learning Model}
\usage{
eztune_cv(x, y, model, cross = 10)
}
\arguments{
\item{x}{Matrix or data frame containing the dependent variables used
to create the model.}

\item{y}{Vector of the response used to create the model. Can be either
numeric or a factor.}

\item{model}{An Object of class \code{eztune} generated by the
function \code{eztune}.}

\item{cross}{Number of folds to use for n-fold cross-validation.}
}
\value{
Function returns a numeric value that represents the
cross-validated accuracy of the model. Both classification accuracy
and the AUC are returned for models with a binary response. MSE and
mean absolute error (MAE) are returned for models with a continuous
response.
\item{accuracy}{Cross-validated classification accuracy.}
\item{auc}{Cross-validated AUC.}
\item{mse}{Cross-validated MSE.}
\item{mae}{Cross-validated MAE.}
}
\description{
\code{eztune_cv} returns the cross-validated
loss measures for a model returned by \code{eztune}.
The function \code{eztune} can tune a model using validation data,
cross validation, data splitting, or resubstitution. If resubstitution
or a data splitting method (via the \code{fast} option) is used to
tune the model, the accuracy obtained from the function
may not be accurate. The function \code{eztune_cv} will return
cross-validated accuracy measures for any model returned by \code{eztune}.
}
\examples{
library(mlbench)
data(Sonar)
sonar <- Sonar[sample(1:nrow(Sonar), 100), ]

y <- sonar[, 61]
x <- sonar[, 1:10]

sonar_default <- eztune(x, y)
eztune_cv(x, y, sonar_default)

sonar_svm <- eztune(x, y, fast = FALSE, cross = 3)
eztune_cv(x, y, sonar_svm)

sonar_gbm <- eztune(x, y, method = "gbm", fast = 50)
eztune_cv(x, y, sonar_gbm)


}
