% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EXRQ.R
\name{PowT.1tau.func}
\alias{PowT.1tau.func}
\title{Estimation for Quantile Power Transformation Model}
\usage{
PowT.1tau.func(y, x, tau, lams = seq(-2, 2, 0.1), a)
}
\arguments{
\item{y}{a vector of length n representing the response}

\item{x}{a n x p matrix of n observations and p predictors}

\item{tau}{the quantile level of interest}

\item{lams}{a set of transformation parameters for grid search}

\item{a}{the location shift}
}
\value{
A list is returned with the following components

lam: the estimated transformation parameter

coef: the estimated quantile coefficient from the power-transformed linear quantile regression
}
\description{
This function estimates the power transformation
parameter at a single given quantile level
}
\details{
This function estimates the transformation parameter lam following
the estimation method in Mu and He (2007) such that the conditional
quantile of the transformed response is linear in covariates.
The transformed response is defined as
\deqn{\Lambda(y) =
{(y+a)^\lambda-1}\lambda, if \lambda \neq 0; =log(y+a) if \lambda=0.
}
}
\references{
Mu, Y. and He, X. (2007). Power transformation toward a linear
regression quantile. Journal of the American Statistical Association, 102, 269-279.
}

