% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cEVI_fun.R
\name{cEVI_fun}
\alias{cEVI_fun}
\title{Calculation of the convergence Epidemic Volatility Index}
\usage{
cEVI_fun(cases, lag_n, c_n)
}
\arguments{
\item{cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{lag_n}{Integer. Restriction of the window size for the rolling window size.}

\item{c_n}{threshold alpha-level value (0 <= c <= 0.5) for issuing an early warning. If cevi <= c_n an early warning is issued and otherwise is not.

For each time point the stored variables are:}
}
\value{
\itemize{
\item{Dates: the date for each time point (with origin 01-01-1970).}

\item{Days: the serial number for each time point.}

\item{EVI: the estimated EVI for each time point.}}
}
\description{
This sencondary function produces the convergence Epidemic Volatility Index based on input data.
}
\examples{
cEVI_fun(cases=c(0,0,1,3,4,10,40,90,105,160,210,301,510,670,680,650,670,665),lag_n=3,c_n=0.1)
}
\references{
Pateras K, Meletis E, Denwood M, et al. The convergence epidemic index (cEVI) an early warning tool for identifying waves in an epidemic. Inf Dis Mod, (2023)
}
