% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_phase1.R
\name{phase1}
\alias{phase1}
\title{Core function for Phase 1}
\usage{
phase1(
  startingestimates,
  inv.zcov,
  inv.scaling,
  z.phase1,
  z.obs,
  nodes,
  effects,
  objects,
  r.truncation.p1,
  length.p1,
  fixed.estimates,
  verbose = FALSE
)
}
\arguments{
\item{startingestimates}{vector containing initial parameter values}

\item{inv.zcov}{inverted covariance matrix}

\item{inv.scaling}{scaling matrix}

\item{z.phase1}{statistics retrieved from phase 1}

\item{z.obs}{observed statistics}

\item{nodes}{node set (data frame)}

\item{effects}{effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{r.truncation.p1}{numeric used to limit extreme values in the covariance matrix (for stability)}

\item{length.p1}{number of samples in phase 1}

\item{fixed.estimates}{if some parameters are fixed, list with as many elements as effects, these elements equal a fixed value if needed, or NULL if they should be estimated}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
estimated parameters after phase 1
}
\description{
Core function for Phase 1
}
