% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalytic_est.R
\name{catalytic_est}
\alias{catalytic_est}
\title{Function for estimating the catalytic constant}
\usage{
catalytic_est(
  method,
  timespan,
  products,
  enz,
  subs,
  K_M,
  catal_m,
  catal_v,
  nrepeat,
  jump,
  burn,
  volume,
  t_unit,
  c_unit
)
}
\arguments{
\item{method}{This determines which model, the sQSSA or tQSSA model, is used for the estimation. Specifically, the input for method is TRUE (FALSE); then the tQSSA (sQSSA) model is used.}

\item{timespan}{time points when the concentrations of products were measured.}

\item{products}{measured concentrations of products}

\item{enz}{initial enzyme concentrations}

\item{subs}{initial substrate concentrations}

\item{K_M}{true value of the Michaelis-Menten constant.}

\item{catal_m}{prior mean of gamma prior for the catalytic constant k_cat.}

\item{catal_v}{prior variance of gamma prior for the catalytic constant k_cat.}

\item{nrepeat}{number of effective iteration, i.e., posterior samples.}

\item{jump}{length of distance between sampling, i.e., thinning rate.}

\item{burn}{length of burn-in period.}

\item{volume}{the volume of a system. It is used to scale the product concentration. FALSE input provides automatic scaling.}

\item{t_unit}{the unit of time points. It can be an arbitrary string.}

\item{c_unit}{the unit of concentrations. It can be an arbitrary string.}
}
\value{
A vector containing posterior samples of the estimated parameter: the catalytic constant.
}
\description{
The function estimates catalytic constant using progress-curve data,
enzyme concentrations, substrate concentrations, and the Michaelis-Meten constant.
}
\details{
The function catalytic_est generates a set of Monte Carlo
simulation samples from posterior distribution of the catalytic constant of enzyme kinetics model.
Because the function estimates only the catalytic constant, the true value of the Michaelis-Menten constant should be given.
Authors' recommendation: "Do not use this function directly. Do use the function main_est()
to estimate the parameter so that the main function calls this function"
}
\examples{
\dontrun{
data("timeseries_data_example")
timespan1=timeseries_data_example[,c(1,3,5,7)]
products1=timeseries_data_example[,c(2,4,6,8)]
catalytic_result <- catalytic_est(method=TRUE,timespan=timespan1,
products=products1,enz = c(4.4, 4.4, 440, 440), subs=c(4.4, 4.4, 4.4, 4.4), 
K_M=44, catal_m = 1, catal_v = 1000, jump = 10, burn = 1000, nrepeat = 1000, 
volume = FALSE, t_unit = "sec", c_unit = "mM")
}
}
