% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEML.R
\name{EEML}
\alias{EEML}
\title{Ensemble Explainable Machine Learning Models}
\usage{
EEML(df, Weight)
}
\arguments{
\item{df}{List of dataframes containing various explainable scores for each model}

\item{Weight}{Ensemble weights of the models (from weight function)}
}
\value{
\itemize{
  \item ImpScore: Final variable important score of EEML model
}
}
\description{
Ensemble Explainable Machine Learning Models
}
\examples{
\donttest{
library("EEML")
df1<- as.data.frame(matrix(rnorm(50) , nrow = 10) )
df2<- as.data.frame(matrix(rnorm(50) , nrow = 10) )
df3<- as.data.frame(matrix(rnorm(50) , nrow = 10) )
rownames(df1)<- rownames(df2)<-rownames(df3)<-paste0("Var", seq(1,10,1))
colnames(df1)<- colnames(df2)<-colnames(df3)<-paste0("Exp", seq(1,5,1))
DF<- list(df1, df2, df3)
EEML<-EEML(df=DF,Weight=NULL)
}
}
\references{
\itemize{
\item Paul, R.K., Das, T. and Yeasin, M., 2023. Ensemble of time series and machine learning model for forecasting volatility in agricultural prices. National Academy Science Letters, 46(3), pp.185-188.
\item Yeasin, M. and Paul, R.K., 2024. OptiSembleForecasting: optimization-based ensemble forecasting using MCS algorithm and PCA-based error index. The Journal of Supercomputing, 80(2), pp.1568-1597.
}
}
