% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_journal_citation.R
\name{delete_journal_citation}
\alias{delete_journal_citation}
\title{Delete journal citation}
\usage{
delete_journal_citation(journalCitationId, env = "production")
}
\arguments{
\item{journalCitationId}{(numeric) Journal citation identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(logical) TRUE if deleted
}
\description{
Delete journal citation
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create journal citation
journalCitationId <- create_journal_citation(
  packageId = "edi.17.1",
  articleDoi = "https://doi.org/10.1890/11-1026.1",
  articleTitle = "Corridors promote fire via connectivity and edge effects",
  journalTitle = "Ecological Applications",
  relationType = "IsCitedBy",
  env = "staging"
)
journalCitationId
#> [1] 74

# Delete journal citation
delete_journal_citation(journalCitationId, env = "staging")
#> [1] TRUE

logout()
}

}
\seealso{
Other Journal Citations: 
\code{\link{create_journal_citation}()},
\code{\link{get_journal_citation}()},
\code{\link{list_data_package_citations}()},
\code{\link{list_principal_owner_citations}()}
}
\concept{Journal Citations}
