% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearity.R
\name{linearity}
\alias{linearity}
\alias{linearity.default}
\alias{linearity.formula}
\title{Measures of linearity}
\usage{
linearity(...)

\method{linearity}{default}(x, y, measures = "all", summary = c("mean",
  "sd"), ...)

\method{linearity}{formula}(formula, data, measures = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A response vector with one value for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{summarization} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the output column.}

\item{data}{A data.frame dataset contained the input attributes and class.}
}
\value{
A list named by the requested linearity measure.
}
\description{
The linearity measures try to quantify if it is possible to separate the 
labels by a hyperplane or linear function. The underlying assumption is that 
a linearly separable problem can be considered simpler than a problem
requiring a non-linear decision boundary.
}
\details{
The following classification measures are allowed for this method:
 \describe{
   \item{"L1"}{Sum of the error distance by linear programming (L1) computes 
     the sum of the distances of incorrectly classified examples to a linear 
     boundary used in their classification.}
   \item{"L2"}{Error rate of linear classifier (L2) computes the error rate 
     of the linear SVM classifier induced from dataset.}
   \item{"L3"}{Non-linearity of a linear classifier (L3) creates a new 
     dataset randomly interpolating pairs of training examples of the same 
     class and then induce a linear SVM on the original data and measure 
     the error rate in the new data points.}
 }
 The following regression measures are allowed for this method:
 \describe{
   \item{"L1"}{Mean absolute error (L1) averages the absolute values of the 
     residues of a multiple linear regressor.}
   \item{"L2"}{Residuals variance (L2) averages the square of the residuals 
     from a multiple linear regression.}
   \item{"L3"}{Non-linearity of a linear regressor (L3) measures how 
     sensitive the regressor is to the new randomly interpolated points.}
 }
}
\examples{
## Extract all linearity measures for classification task
data(iris)
linearity(Species ~ ., iris)

## Extract all linearity measures for regression task
data(cars)
linearity(speed ~ ., cars)
}
\references{
Albert Orriols-Puig, Nuria Macia and Tin K Ho. (2010). Documentation for the
   data complexity library in C++. Technical Report. La Salle - Universitat 
   Ramon Llull.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{correlation}}, \code{\link{dimensionality}},
  \code{\link{neighborhood}}, \code{\link{network}},
  \code{\link{overlapping}}, \code{\link{smoothness}}
}
\concept{complexity-measures}
