% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewma.R
\name{ewma}
\alias{ewma}
\title{EWMA chart statistics of the data}
\usage{
ewma(data, lambda, EWMA0)
}
\arguments{
\item{data}{An one-dimensional random variable.}

\item{lambda}{An EWMA smooth constant, which is a scalar in [0,1].}

\item{EWMA0}{A starting point of EWMA charting statistic.}
}
\value{
A vector of EWMA charting statistics of \code{data} at different t times.
}
\description{
A conventional exponential weighted moving average (EWMA) charting statistic evaluated by the data.
}
\examples{
x = rnorm(20,0,1)
ewma(x,0.05,0)
}
