# <img src="man/figures/logo.png" align="right" height="120" />
# Durga: An R package for effect size estimation and visualisation

<!-- badges: start -->
[![R-CMD-check](https://github.com/KhanKawsar/EstimationPlot/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/KhanKawsar/EstimationPlot/actions/workflows/R-CMD-check.yaml)
[![Codecov test coverage](https://codecov.io/gh/KhanKawsar/EstimationPlot/branch/main/graph/badge.svg)](https://app.codecov.io/gh/KhanKawsar/EstimationPlot?branch=main)
[![CRAN status](https://www.r-pkg.org/badges/version/Durga)](https://CRAN.R-project.org/package=Durga)
![CRAN download count](https://cranlogs.r-pkg.org/badges/Durga)
<!-- badges: end -->


Effect size estimation and plotting is a component of [estimation statistics](https://en.wikipedia.org/wiki/Estimation_statistics). `Durga` is an R package that aims to simplify sophisticated plotting of estimated differences in group means, which is an important part of communicating estimation statistics.

## Citation

If you use `Durga` in your research, please cite (and read) the article:

Khan, M. K., & McLean, D. J. (2024). Durga: An R package for effect size estimation and visualisation. _Journal of Evolutionary Biology_. [doi:10.1093/jeb/voae073](https://doi.org/10.1093/jeb/voae073)


## Installation

To install the released version:

    > install.packages("Durga")

To install the development version:

    > install.packages("devtools") # If not already installed
    > devtools::install_github("KhanKawsar/EstimationPlot", build_vignettes = TRUE)

Refer to [NEWS.md](NEWS.md) for a list of changes in each version, including changes in the current development version. You can read the news for an installed package by running:

    > news(package = "Durga")

## Usage
 
Read the paper [Khan & McLean (2023)](https://doi.org/10.1101/2023.02.06.526960) for a detailed description of the package. Once Durga is installed, you can read the vignette named `Introduction to Durga` for a shorter introduction to using Durga, complete with examples and code.

```R
# Display the vignette in a browser
RShowDoc("Durga-intro", package = "Durga")

# Display the vignette in the help window pane
vignette("Durga-intro", package = "Durga")
```

A minimal example using constructed data:

```R
  n <- 100
  df <- data.frame(val = c(rnorm(n), rnorm(n, mean = 1)),
                   group = c(rep("Control", n), rep("Group", n)))

  d <- DurgaDiff(df, data.col = "val", group.col = "group")
  # or equivalently
  d <- DurgaDiff(val ~ group, df)
  DurgaPlot(d)
```

<img src="https://github.com/KhanKawsar/EstimationPlot/blob/main/eg.png?raw=true"></img>

<!-- To create the above PNG, run the example above, then run:
JPlotToPNG("eg.png", { par(mar = c(5, 4, 1, 1) + 0.1); DurgaPlot(d)}, width = 600)
-->


## Development Environment
<!-- Output from devtools::session_info() -->

```
─ Packages ─────────────────────────────────────────────────────────────────────────────────────────
 package     * version  date (UTC) lib source
 cachem        1.1.0    2024-05-16 [1] CRAN (R 4.4.2)
 cli           3.6.3    2024-06-21 [1] CRAN (R 4.4.2)
 devtools      2.4.5    2022-10-11 [1] CRAN (R 4.4.2)
 digest        0.6.37   2024-08-19 [1] CRAN (R 4.4.2)
 ellipsis      0.3.2    2021-04-29 [1] CRAN (R 4.4.2)
 evaluate      1.0.3    2025-01-10 [1] CRAN (R 4.4.2)
 fastmap       1.2.0    2024-05-15 [1] CRAN (R 4.4.2)
 fs            1.6.5    2024-10-30 [1] CRAN (R 4.4.2)
 glue          1.8.0    2024-09-30 [1] CRAN (R 4.4.2)
 htmltools     0.5.8.1  2024-04-04 [1] CRAN (R 4.4.2)
 htmlwidgets   1.6.4    2023-12-06 [1] CRAN (R 4.4.2)
 httpuv        1.6.15   2024-03-26 [1] CRAN (R 4.4.2)
 knitr         1.49     2024-11-08 [1] CRAN (R 4.4.2)
 later         1.4.1    2024-11-27 [1] CRAN (R 4.4.2)
 lifecycle     1.0.4    2023-11-07 [1] CRAN (R 4.4.2)
 magrittr      2.0.3    2022-03-30 [1] CRAN (R 4.4.2)
 memoise       2.0.1    2021-11-26 [1] CRAN (R 4.4.2)
 mime          0.12     2021-09-28 [1] CRAN (R 4.4.0)
 miniUI        0.1.1.1  2018-05-18 [1] CRAN (R 4.4.2)
 pkgbuild      1.4.5    2024-10-28 [1] CRAN (R 4.4.2)
 pkgload       1.4.0    2024-06-28 [1] CRAN (R 4.4.2)
 profvis       0.4.0    2024-09-20 [1] CRAN (R 4.4.2)
 promises      1.3.2    2024-11-28 [1] CRAN (R 4.4.2)
 purrr         1.0.2    2023-08-10 [1] CRAN (R 4.4.2)
 R6            2.5.1    2021-08-19 [1] CRAN (R 4.4.2)
 Rcpp          1.0.13-1 2024-11-02 [1] CRAN (R 4.4.2)
 remotes       2.5.0    2024-03-17 [1] CRAN (R 4.4.2)
 rlang         1.1.4    2024-06-04 [1] CRAN (R 4.4.2)
 rmarkdown     2.29     2024-11-04 [1] CRAN (R 4.4.2)
 rstudioapi    0.17.1   2024-10-22 [1] CRAN (R 4.4.2)
 sessioninfo   1.2.2    2021-12-06 [1] CRAN (R 4.4.2)
 shiny         1.10.0   2024-12-14 [1] CRAN (R 4.4.2)
 urlchecker    1.0.1    2021-11-30 [1] CRAN (R 4.4.2)
 usethis       3.1.0    2024-11-26 [1] CRAN (R 4.4.2)
 vctrs         0.6.5    2023-12-01 [1] CRAN (R 4.4.2)
 xfun          0.50     2025-01-07 [1] CRAN (R 4.4.2)
 xtable        1.8-4    2019-04-21 [1] CRAN (R 4.4.2)
 yaml          2.3.10   2024-07-26 [1] CRAN (R 4.4.2)
 ```
