% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrImpute.R
\name{DrImpute}
\alias{DrImpute}
\title{Imputing dropout events in single-cell RNA-sequencing data.}
\usage{
DrImpute(X, ks = 10:15, dists = c("spearman", "pearson"), method = "mean",
  cls = NULL, seed = 1, zerop = 0)
}
\arguments{
\item{X}{Gene expression matrix (gene by cell).}

\item{ks}{Number of cell clustering groups. Default set to ks = 10:15.}

\item{dists}{Distribution matrices to use. Default is set to c("spearman", "pearson"). "eucleadian" can be added as well.}

\item{method}{Use "mean" for mean imputation, "med" for median imputation.}

\item{cls}{User can manually provide clustering information. Using different base clusterings. each row represent different clusterings. each column represent each cell.}

\item{seed}{User can provide a seed.}

\item{zerop}{zero percentage of resulting imputation is at least zerop.}
}
\value{
Imputed Gene expression matrix (gene by cell).
}
\description{
Imputing dropout events in single-cell RNA-sequencing data.
}
\examples{

data(exdata)
exdata <- preprocessSC(exdata)
exdata <- exdata[1:3000, 1:80]
logdat <- log(exdata+1)
cls <- getCls(logdat)
logdat_imp <- DrImpute(logdat, cls = cls)

}
\references{
Il-Youp Kwak, Wuming Gong, Kaoko Koyano-Nakagawa and Daniel J. Garry (2017+)
DrImpute: Imputing dropout eveents in single cell RNA sequencing data
}
\author{
Il-Youp Kwak
}
