\name{CLX}
\alias{CLX}
\title{Two-Sample CLX Test for High-Dimensional Data}
\description{
  Performs a two-sample CLX test to compare the means of two high-dimensional samples.
  This test is suitable for situations where the number of variables \( p \) is large relative to the sample sizes.
}
\usage{
CLX(X, Y, alpha)
}
\arguments{
  \item{X}{A numeric matrix representing the first sample, where rows are variables and columns are observations.}
  \item{Y}{A numeric matrix representing the second sample, where rows are variables and columns are observations.}
  \item{alpha}{The significance level for the test (e.g., 0.05).}
}
\details{
  The CLX test is designed to handle high-dimensional data by estimating the covariance matrix,
  applying thresholding to reduce noise, and transforming the data to white noise.
  The test statistic  is calculated based on the maximum squared difference between the mean vectors,
  weighted by the inverse of the variances.
}
\value{
  A list containing the following components:
  \item{statistics}{The test statistic.}
  \item{p.value}{The p-value of the test.}
  \item{alternative}{The alternative hypothesis ("two.sided").}
  \item{method}{The method used ("Two-Sample CLX test").}
}
\examples{
  # Example usage:
  set.seed(123)
  p <- 100  # Number of variables
  n1 <- 20  # Sample size for X
  n2 <- 20  # Sample size for Y
  X <- matrix(rnorm(n1 * p), nrow = p, ncol = n1)
  Y <- matrix(rnorm(n2 * p, mean = 0.5), nrow = p, ncol = n2)
  result <- CLX(X, Y, alpha = 0.05)
  print(result)
}
\seealso{
  \code{\link{eigen}}: Used for eigen-decomposition of the covariance matrix.
  \code{\link{solve}}: Used to compute the inverse of the covariance matrix.
}
