% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_path.R
\name{add_path}
\alias{add_path}
\title{Add a path of nodes to the graph}
\usage{
add_path(
  graph,
  n,
  type = NULL,
  label = TRUE,
  rel = NULL,
  node_aes = NULL,
  edge_aes = NULL,
  node_data = NULL,
  edge_data = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{n}{The number of nodes comprising the path.}

\item{type}{An optional string that describes the entity type for the nodes
to be added.}

\item{label}{Either a vector object of length \code{n} that provides optional
labels for the new nodes, or, a logical value where setting to \code{TRUE}
ascribes node IDs to the label and \code{FALSE} yields a blank label.}

\item{rel}{An optional string for providing a relationship label to all new
edges created in the node path.}

\item{node_aes}{An optional list of named vectors comprising node aesthetic
attributes. The helper function \code{\link[=node_aes]{node_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted node aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{color}, \code{fillcolor}).}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{node_data}{An optional list of named vectors comprising node data
attributes. The helper function \code{\link[=node_data]{node_data()}} is strongly recommended for
use here as it helps bind data specifically to the created nodes.}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add a node path to the graph.
}
\examples{
# Create a new graph and add
# 2 paths of varying lengths
graph <-
  create_graph() \%>\%
  add_path(
    n = 4,
    type = "path") \%>\%
  add_path(
    n = 5,
    type = "path")

# Get node information
# from this graph
graph \%>\% get_node_info()

# Node and edge aesthetic and data
# attributes can be specified in
# the `node_aes`, `edge_aes`,
# `node_data`, and `edge_data`
# arguments

suppressWarnings(RNGversion("3.5.0"))
set.seed(23)

graph_w_attrs <-
  create_graph() \%>\%
  add_path(
    n = 3,
    label = c(
      "one", "two", "three"),
    type = c(
      "a", "a", "b"),
    rel = "A",
    node_aes = node_aes(
      fillcolor = "steelblue"),
    edge_aes = edge_aes(
      color = "red",
      penwidth = 1.2),
    node_data = node_data(
      value = c(
        1.6, 2.8, 3.4)),
    edge_data = edge_data(
      value =
        rnorm(
          n = 2,
          mean = 5.0,
          sd = 1.0)))

# Get the graph's node data frame
graph_w_attrs \%>\% get_node_df()

# Get the graph's edge data frame
graph_w_attrs \%>\% get_edge_df()

}
