% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin_multi_stage.R
\name{kin_multi_stage}
\alias{kin_multi_stage}
\title{Estimate kin counts by age and stage in a time invariant framework}
\usage{
kin_multi_stage(
  U = NULL,
  f = NULL,
  D = NULL,
  H = NULL,
  birth_female = 1/2.04,
  output_kin = NULL,
  parity = FALSE,
  list_output = FALSE
)
}
\arguments{
\item{U}{list. age elements with column-stochastic transition matrix with dimension for the state space, conditional on survival.}

\item{f}{matrix. state-specific fertility (age in rows and states in columns). Is accepted also a list with for each age-class.}

\item{D}{matrix. survival probabilities by state (age in rows and states in columns). Is accepted also a list for each state with survival matrices.}

\item{H}{matrix. assigns the offspring of individuals in some stage to the appropriate age class (age in rows and states in columns). Is accepted also a list with a matrix for each state.}

\item{birth_female}{numeric. Female portion at birth.}

\item{output_kin}{character. kin to return. For example "m" for mother, "d" for daughter. See the \code{vignette} for all kin types.}

\item{parity}{logical. parity states imply age distribution of mothers re-scaled to not have parity 0 when Focal born. Default \code{TRUE}.}

\item{list_output}{logical. Results as a list. Default \code{FALSE}.}
}
\value{
A data frame with focal´s age, related ages and type of kin
(for example \code{d} is daughter, \code{oa} is older aunts, etc.), living and death kin counts, and specific stage. If \code{list_output = TRUE} then this is a list with elements as kin types.
}
\description{
Implementation of age-stage kin estimates (multi-state) by Caswell (2020). Stages are implied in length of input lists.
}
