% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_album_popularity.R
\name{get_album_popularity}
\alias{get_album_popularity}
\title{Get Album Popularity}
\usage{
get_album_popularity(album_uri, limit = 1, offset = 0,
  access_token = DSpoty::get_spotify_access_token())
}
\arguments{
\item{album_uri}{An album uri from Spotify to search for or a group of albums uris separated by a comma}

\item{limit}{Integer indicating the max number of artists to return. Defaults to 1, max of 50.}

\item{offset}{Integer indicating the offset of the first artist to return. Defaults to 0 (Spotify's API default value).}

\item{access_token}{Spotify Web API token. Defaults to DSpoty::get_spotify_access_token()}
}
\value{
Returns an integer vector with the popularity value (0-100).
}
\description{
This function returns the popularity of an album on Spotify.
}
\examples{
\dontrun{
get_album_popularity('1T2uKSyUf7DBWOABtsmYLM')
}
}
\author{
Alberto Almui?a
}
