% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FieldMap.R
\name{fieldMap}
\alias{fieldMap}
\title{Field Map}
\usage{
fieldMap(
  area,
  site.density,
  site.area,
  overlap = 0.5,
  plot = FALSE,
  areaprecision = 1000
)
}
\arguments{
\item{area}{vector with horizontal and vertical size \verb{(hor,ver)} of area surveyed in km.}

\item{site.density}{number of sites/\ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}. Can be one constant value or vector with two values \verb{(min, max)} to
create a range of densities between simulations.}

\item{site.area}{either:
\itemize{
\item One values with uniform area for all sites, or
\item Vector with 4 values \verb{(min, max, mean, st dev)}, to create variable areas. areas in this case
are normally distributed based on mean and stdev, but within the range of min and max.
}}

\item{overlap}{proportion of overlap possible between sites: from (0 = no overlap allowed to 1 = sites can occupy same space)}

\item{plot}{whether site ellipses should should be plotted.}

\item{areaprecision}{value passed to \code{areaEstimator}. Defines precision of area calculation. Default value (\code{1000}), returns area within 0.1\% of real area occupied by sites}
}
\value{
A list with three objects: \tabular{ll}{
\code{site.frame} \tab A matrix with the properties of each site generated. \cr
\tab \cr
\code{totalArea} \tab The sum of areas of all site ellipses.\cr
\tab \cr
\code{actualArea} \tab The area occupied by the site ellipses taking into account their overlap)\cr
}
}
\description{
Creates randomly placed ellipsoid sites in a rectangular field.
}
\details{
\code{fieldMap()} creates and plots randomly placed ellipses representing
archaeological sites. The sites are created inside a user-defined rectangle, with random positions
and random rotations. It allows also to control the percentage of overlap between sites.
}
\examples{
#example of map with 8 sites or variable areas and partial overlap
field.example<-fieldMap(
                 area=c(1,1),
                 site.density=8,
                 site.area=c(50000,250000,150000,50000),
                 overlap=0.5,
                 plot=TRUE)

}
