% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCDIF.R
\name{Cdif}
\alias{Cdif}
\title{Calculates CDIF index for an item with given item parameters of focal and reference groups.}
\usage{
Cdif(
  itemParameters,
  irtModel = "2pl",
  focalAbilities = NULL,
  focalDistribution = "norm",
  subdivisions = 5000,
  logistic = TRUE,
  focalDistrExtra = list(mean = 0, sd = 1)
)
}
\arguments{
\item{itemParameters}{A list containing "focal" and "reference" item parameters. Item parameters are assumed to be on the same scale. Item parameters for each group should me a matrix with nrow equal to the number of items.}

\item{irtModel}{A string stating the irtModel to be used. Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

\item{focalAbilities}{If NULL, NCDIF is calculated by numerical integration of focal distribution. If not NULL, it must be a numerical vector containing the abilities for the individuals in the focal group.}

\item{focalDistribution}{A string stating the distribution name to be used for integrating. Only used if focalAbilities is NULL.}

\item{subdivisions}{A numeric value indicating the number of subdivisions for numerical integration. Only used if focalAbilities is NULL.}

\item{logistic}{A logical value stating if the IRT model will use the logistic or the normal metric. Defaults to using the logistic metric by fixing the D constant to 1. If FALSE the constant is set to 1.702 so that the normal metric is used.}

\item{focalDistrExtra}{Extra parameters for the focal group distribution function if needed.}
}
\value{
cdif Numeric vector with the CDIF index value for each item.
}
\description{
Calculates CDIF index for an item with given item parameters of focal and reference groups.
}
\examples{

# # Not run
# #
# # data(dichotomousItemParameters)
# #
# # threePlParameters <- dichotomousItemParameters
# # isNot3Pl          <- ((dichotomousItemParameters[['focal']][, 3] == 0) |
# #                       (dichotomousItemParameters[['reference']][, 3] == 0))
# #
# # threePlParameters[['focal']]          <- threePlParameters[['focal']][!isNot3Pl, ]
# # threePlParameters[['reference']]      <- threePlParameters[['reference']][!isNot3Pl, ]
# # threePlParameters[['focal']][, 3]     <- threePlParameters[['focal']][, 3] + 0.1
# # threePlParameters[['reference']][, 3] <- threePlParameters[['reference']][, 3] + 0.1
# # threePlParameters[['focal']][, 2]     <- threePlParameters[['focal']][, 2] + 1.5
# # threePlParameters[['reference']][, 2] <- threePlParameters[['reference']][, 2] + 1.5
# # threePlParameters[['focal']]          <- threePlParameters[['focal']][-c(12, 16, 28), ]
# # threePlParameters[['reference']]      <- threePlParameters[['reference']][-c(12, 16, 28), ]
# #
# # threePlCdif <- Cdif(itemParameters = dichotomousItemParameters, irtModel = '3pl',
# #                     focalAbilities = NULL, focalDistribution = "norm",
# #                     subdivisions = 5000, logistic = TRUE)

}
\references{
Raju, N. S., van der Linden, W. J., & Fleer, P. F. (1995). IRT-based internal measures of differential functioning of items and tests. Applied Psychological Measurement, 19, 353--368. doi:10.1177/014662169501900405
}
\author{
Victor H. Cervantes <vhcervantesb at unal.edu.co>
}
