% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dEploidPlotly.R
\name{plotAltVsRefPlotly}
\alias{plotAltVsRefPlotly}
\title{Plot coverage}
\usage{
plotAltVsRefPlotly(ref, alt, title = "Alt vs Ref", potentialOutliers = c())
}
\arguments{
\item{ref}{Numeric array of reference allele count.}

\item{alt}{Numeric array of alternative allele count.}

\item{title}{Figure title, "Alt vs Ref" by default}

\item{potentialOutliers}{Index of potential outliers.}
}
\description{
Plot alternative allele count vs reference allele count at each
 site.
}
\examples{
# Example 1
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT <- extractCoverageFromTxt(refFile, altFile)
plotAltVsRefPlotly(PG0390CoverageT$refCount, PG0390CoverageT$altCount)

# Example 2
vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV <- extractCoverageFromVcf(vcfFile, "PG0390-C")
plotAltVsRefPlotly(PG0390CoverageV$refCount, PG0390CoverageV$altCount)

}
