% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{detectSex}
\alias{detectSex}
\title{Detect the sex for some demographic data}
\usage{
detectSex(Dat, sexColumn = "Sex")
}
\arguments{
\item{Dat}{a \code{data.frame} containing a column called \code{Sex}, or code{sex}.}

\item{sexColumn}{character string giving the name of the Sex column \code{"Sex"} assumed.}
}
\value{
either \code{"f"} or \code{"m"}
}
\description{
The column name can be \code{"sex"} or \code{"Sex"} and nothing else. If coded with integer, the number 1 is recognized as male and numbers, 0, 2, or 6 are assumed to be female. Any other integer will throw an error. If character, if the first letter is \code{"f"}, then we assume female, and if the first letter is \code{"m"} we assume male. Case does not matter. Anything else will throw an error. This function allows for just a little flexibility.
}
