% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{HMDlogic}
\alias{HMDlogic}
\alias{logic}
\alias{HMDutils}
\alias{\%==\%}
\alias{\%!=\%}
\alias{\%>\%}
\alias{\%<\%}
\alias{\%>=\%}
\alias{\%<=\%}
\title{Logical utility functions}
\usage{
x \%==\% y

x \%!=\% y

x \%>\% y

x \%<\% y

x \%>=\% y

x \%<=\% y
}
\arguments{
\item{x, y}{any two vectors that can be logically compared.}
}
\description{
These logical functions are like the usual ones, but \code{NA} values are treated as \code{FALSE} by default. This is not an exhaustive list, but these are the ones that speed our coding, and reduce code clutter. Functions copied from HMD collection directly as-is.
}
\details{
Note that one of these, \code{\%>\%} makes this package incompatible with the \code{magrittr} package.
}
\examples{
\dontrun{
c(1,2,NA,4,5) == c(1,NA,3,4,NA)
# compare
c(1,2,NA,4,5) \%==\% c(1,NA,3,4,NA)
}
}
