% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutAnno.R
\name{plotMutAnno}
\alias{plotMutAnno}
\title{Plot the mutation statistics after annotating the "nucmer" object by "indelSNP" function}
\usage{
plotMutAnno(covid_annot = covid_annot, figureType = "MostMut", outdir = NULL)
}
\arguments{
\item{covid_annot}{The mutation effects provided by "indelSNP" function.}

\item{figureType}{Figure type for: "MostMut", "MutPerSample", "VarClasses", "VarType", "NucleoEvents", "ProEvents".}

\item{outdir}{The output directory.}
}
\value{
Plot the selected figure type as output.
}
\description{
Basic descriptions for the mutational events.
}
\examples{
data("covid_annot")
# make sure the covid_annot is a dataframe
covid_annot <- as.data.frame(covid_annot)
#outdir <- tempdir() specify your output directory
plotMutAnno(covid_annot = covid_annot, figureType = "MostMut", outdir = NULL)
}
