% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidBoolean}
\alias{stopOnInvalidBoolean}
\title{Parameter Function stopOnInvalidBoolean}
\usage{
stopOnInvalidBoolean(paramCheckResult, boolean)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{boolean}{parameter which is checked if it is a valid boolean.}
}
\description{
stopOnInvalidBoolean checks definition is the parameter a boolean
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1120 \tab Parameter is not a boolean value \cr
1121 \tab Parameter is not of length 1 }
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validBoolean = TRUE
stopOnInvalidBoolean(paramCheckResult, validBoolean)

}
\seealso{
Other ParameterChecks_CoopGame: 
\code{\link{getEmptyParamCheckResult}()},
\code{\link{stopOnInconsistentEstateAndClaimsVector}()},
\code{\link{stopOnInvalidAllocation}()},
\code{\link{stopOnInvalidClaimsVector}()},
\code{\link{stopOnInvalidCoalitionS}()},
\code{\link{stopOnInvalidDictator}()},
\code{\link{stopOnInvalidEstate}()},
\code{\link{stopOnInvalidGameVector}()},
\code{\link{stopOnInvalidGrandCoalitionN}()},
\code{\link{stopOnInvalidIndex}()},
\code{\link{stopOnInvalidLeftRightGloveGame}()},
\code{\link{stopOnInvalidNChooseB}()},
\code{\link{stopOnInvalidNumberOfPlayers}()},
\code{\link{stopOnInvalidNumber}()},
\code{\link{stopOnInvalidQuota}()},
\code{\link{stopOnInvalidVetoPlayer}()},
\code{\link{stopOnInvalidWeightVector}()},
\code{\link{stopOnParamCheckError}()}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Franz Mueller
}
\concept{ParameterChecks_CoopGame}
