% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{proportionalNucleolus}
\alias{proportionalNucleolus}
\title{Compute proportional nucleolus}
\usage{
proportionalNucleolus(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
proportional nucleolus for specified TU game with n players
}
\description{
proportionalNucleolus calculates the proportional 
nucleolus for a TU game with a non-empty imputation set and 
n players specified by game vector.
Note that the proportional nucleolus is a member of the imputation set.
}
\examples{
library(CoopGame)
v<-c(0,0,0,48,60,72,140)
proportionalNucleolus(v)

}
\references{
Young H. P., Okada N. and Hashimoto, T. (1982) "Cost allocation in water resources development", Water resources research 18(3), pp. 463--475
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
