% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{normalizedBanzhafIndex}
\alias{normalizedBanzhafIndex}
\title{Compute normalized Banzhaf index}
\usage{
normalizedBanzhafIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a numeric vector which contains the normalized Banzhaf index for each player.
}
\description{
Normalized Banzhaf index for a specified simple game, see 
formula (7.6) on p. 119 of the book by Chakravarty, Mitra and Sarkar
}
\examples{
library(CoopGame)
normalizedBanzhafIndex(dictatorGameVector(n=3, dictator=1))

\donttest{
library(CoopGame)
v<-weightedVotingGameVector(n=4,w=c(8,6,4,2),q=c(12))
normalizedBanzhafIndex(v)
#[1] 0.41666667 0.25000000 0.25000000 0.08333333

library(CoopGame) 
v<- apexGameVector(n = 4,apexPlayer=3)
normalizedBanzhafIndex(v)
#[1] 0.1666667 0.1666667 0.5000000 0.1666667

library(CoopGame)
#N=c(1,2,3), w=(50,49,1), q=51   
v=weightedVotingGameVector(n=3, w=c(50,49,1),q=51)
normalizedBanzhafIndex(v)
#[1] 0.6 0.2 0.2

library(CoopGame)
v<-weightedVotingGameVector(n=3,w=c(50,30,20),q=c(67))
normalizedBanzhafIndex(v)
#[1] 0.6 0.2 0.2
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 367--370

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 118--119

Bertini C. and Stach I. (2011) "Banzhaf voting power measure", Encyclopedia of Power, SAGE Publications, pp. 54--55
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
