% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{drawNormalizedBanzhafValue}
\alias{drawNormalizedBanzhafValue}
\title{draw normalized Banzhaf value for 3 or 4 players}
\usage{
drawNormalizedBanzhafValue(
  v,
  holdOn = FALSE,
  colour = NA,
  label = TRUE,
  name = "Normalized Banzhaf value"
)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawNormalizedBanzhafValue draws the Banzhaf Value for 3 or 4 players. \cr
             Drawing any kind of Banzhaf values only makes sense from our point of view 
             for the normalized Banzhaf value, because 
             only in this case will the Banzhaf value be efficient.
}
\examples{
library(CoopGame)
drawNormalizedBanzhafValue(c(0,0,0,1,2,3,6))

\donttest{
#Example from paper by Gambarelli (2011)
library(CoopGame)
v=c(0,0,0,1,2,1,3)
drawNormalizedBanzhafValue(v)
}

}
\references{
Gambarelli G. (2011) "Banzhaf value", Encyclopedia of Power, SAGE Publications, pp. 53--54

Stach I. (2017) "Sub-Coalitional Approach to Values", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXVI, Springer, pp. 74--86
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
