% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpChiValueConcept.R
\name{absolutePublicHelpChiValue}
\alias{absolutePublicHelpChiValue}
\alias{absolutePublicHelpValueChi}
\alias{absolutePublicHelpXiValue}
\alias{absolutePublicHelpValueXi}
\title{Compute absolute Public Help value Chi}
\usage{
absolutePublicHelpChiValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Absolute Public Help value Chi for specified nonnegative game
}
\description{
Calculates the absolute Public Help value Chi for a specified nonnegative TU game.
Note that in general the absolute Public Help value Chi is not an 
efficient vector, i.e. the sum of its entries is not always 1. Hence no 
drawing routine for the absolute Public Help value Chi is provided.
Note that the greek letter Xi (instead of Chi) was used in the 
original paper by Bertini and Stach (2015).
}
\examples{
library(CoopGame)
v=c(0,0,0,2,2,0,2)
absolutePublicHelpChiValue(v) 

}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
