% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_calc_indices.R
\name{sobol_calc_indices}
\alias{sobol_calc_indices}
\title{Calculate sobol indices}
\usage{
sobol_calc_indices(Y, effect_cols, id_cols = character(), run_map)
}
\arguments{
\item{Y}{A data.frame with the desired effect parameter(s) of the model
output, e.g. \code{efflux()}. The output should come from a list of model
results produced by a call to \code{\link{alternate}()} with a valid
\code{cfp_run_map} produced by \code{\link{sobol_run_map}()}.}

\item{effect_cols}{character vector of the column names in \code{Y} for which
sobol indices should be calculated, e.g. \code{'efflux'}.}

\item{id_cols}{character vector of column names in \code{Y} specifying
grouping variables. Indices are then calculated for each group individually.}

\item{run_map}{The \code{cfp_run_map} used for the calculation of Y
produced by a call to \code{\link{sobol_run_map}()}.}
}
\value{
A \code{data.frame} with the following columns
\describe{
\item{\code{...}}{Any \code{id_cols} specified}
\item{\code{param_id, param, pmap}}{Parameter identificators from the
\code{cfp_run_map} used.}
\item{\code{effect_param}}{The parameter for which the effect was calculated.}
\item{\code{Vt, Vi, VY}}{Internal parameters for the indice calculation.}
\item{\code{Si}}{First order sobol indice.}
\item{\code{ST}}{Total order sobol indice.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

From any result parameter and its corresponding \code{cfp_run_map} calculate
first-order and total sobol indices using the Azzini (2021) method.
}
\details{
This implements the approach outlined in Azzini et al (2021).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
PROFLUX <- pro_flux(base_dat)

sobol_map <- sobol_run_map(PROFLUX,
 params = list("TPS" = c(0.9, 1.1),
               "t" = c(0.9, 1.1)),
 type = c("factor", "factor"),
 n_runs = 10)

 PF_sobol <-
alternate(
  PROFLUX,
  \(x) complete_soilphys(x, DSD0_formula = "a*AFPS^b", quiet = TRUE),
  sobol_map)

sobol_calc_indices(efflux(PF_sobol), "efflux", c("site"), sobol_map)

\dontshow{\}) # examplesIf}
}
\references{
Azzini, Ivano; Mara, Thierry A.; Rosati, Rossana: Comparison of
two sets of Monte Carlo estimators of Sobol’ indices, Environmental Modelling
& Software, Volume 144, 2021, 105167, ISSN 1364-8152,
https://doi.org/10.1016/j.envsoft.2021.105167
}
\seealso{
Other sobol: 
\code{\link{sobol_run_map}()}
}
\concept{sobol}
