% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize_depth.R
\name{discretize_depth}
\alias{discretize_depth}
\alias{discretize_depth.cfp_profile}
\alias{discretize_depth.data.frame}
\title{Interpolate over depth to layered profile}
\usage{
discretize_depth(
  df,
  param,
  method,
  depth_target,
  boundary_nearest = FALSE,
  boundary_average = "none",
  int_depth = 0.5,
  knots = NULL,
  ...
)

\method{discretize_depth}{cfp_profile}(
  df,
  param,
  method,
  depth_target,
  boundary_nearest = FALSE,
  boundary_average = "none",
  int_depth = 0.5,
  knots = NULL,
  ...
)

\method{discretize_depth}{data.frame}(
  df,
  param,
  method,
  depth_target,
  boundary_nearest = FALSE,
  boundary_average = "none",
  int_depth = 0.5,
  knots = NULL,
  id_cols = NULL,
  ...
)
}
\arguments{
\item{df}{(dataframe) The dataframe containing the parameters to be
interpolated, as well as the columns "depth", "upper" and "lower".}

\item{param}{(character vector) The column names name of the parameters to be
interpolated.}

\item{method}{(character vector) a character (-vector) specifying the methods
to be used for interpolation. Must be in the same order as param. One of
\itemize{
\item{linear}
\item{boundary}
\item{linspline}
\item{nearest}
\item{harmonic}
}}

\item{depth_target}{(numeric vector or data frame) specifying the new layers.
Must include n+1 depths for n target layers.

If the target layers are different for id_cols, enter a data.frame instead.
This data frame must
have a "depth" column, as well as well as all \code{id_cols} needed that
must be at least a subset of the \code{id_cols} of the original data.}

\item{boundary_nearest}{(logical) = TRUE/FALSE if it is TRUE then for target
depth steps (partially) outside of the parameter boundaries, the nearest
neighbor is returned, else returns NA. Default is FALSE.}

\item{boundary_average}{("character) Defines what happens if the
new layer contains multiple old layers. one of
\describe{
\item{none}{= the default \cr the new layer is set to NA}
\item{arith}{the new layer is calculated as the arithmetic mean of the old}
\item{harm}{the new layer is calculated as the harmonic mean of the old}
}}

\item{int_depth}{(numeric vector)  = value between 0 and 1 for 1 =
interpolation takes the top of each depth step, 0.5 = middle and 0= bottom.
Default = 0.5}

\item{knots}{(numeric vector) = the depths at which knots for the
'linspline' method are to be placed. If this differs for the parameters, a
list of numeric vectors with the same length as "param" can be provided.
Cannot differ between id_cols.}

\item{...}{Internal, must be empty.}

\item{id_cols}{Column names in data.frame that uniquely identify each
profile.}
}
\value{
A \code{\link[=cfp_layered_profile]{cfp_layered_profile()}} data.frame with the variables \code{upper}
and \code{lower} defining the layers derived from depth_target.
The column \code{depth} is the middle of each layer. And all variables from
\code{param}
}
\description{
Interpolate and discretize data into a layered structure.
The output is a data.frame where each profile is separated into layers
that intersect at depths defined in the function call. See
\code{\link[=cfp_layered_profile]{cfp_layered_profile()}}.

There are different interpolation methods implemented, which might be
more practical for different parameters or tasks.
\itemize{
\item A \code{'linear'} interpolation for continuous parameters, (e.g. soil
temperature). \item The
\code{'boundary'} interpolation is only suitable for data that is already
layered. It selects the value from the old layer that in which
the new layer will lay in.
\item
A \code{'linspline'} interpolation fits a linear
spline model to the data with knots defined in  \code{knots}
\item
\code{'nearest'} finds the closest value to the new layer. You can
define whether the closest value should be nearest to the top \code{1},
or bottom \code{0} of the layer using \code{int_depth}
\item
\code{'harmonic'} is similar to a linear interpolation but it uses
the harmonic mean \code{\link[=harm]{harm()}} using the distance in depth to each
value as weights.
}

Multiple variables can be discretized at the same time by supplying
multiple column names in \code{param}.
It is also possible to use different \code{method} and controlling
parameters \code{int_depth} and \code{knots} for each \code{param}.
Just provide a list of settings the same length as \code{param}.
If only one value is given, but multiple \code{param} the settings are
reused for each parameter.
}
\examples{

data("soiltemp")
library(dplyr)

dt <- data.frame(
  site = rep(c("site_a", "site_b"), each = 12),
  depth = c(5, seq(0,-100,-10), 7, seq(0,-100,-10)))

discretize_depth(df = soiltemp,
                 param = "t",
                 method = "linear",
                 depth_target = dt,
                 id_cols = c(
                   "site","Date"))

}
\seealso{
Other soilphys: 
\code{\link{check_soilphys}()},
\code{\link{complete_soilphys}()},
\code{\link{soilphys_layered}()}
}
\concept{soilphys}
