% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_layers_map.R
\name{cfp_layers_map}
\alias{cfp_layers_map}
\alias{cfp_layers_map.cfp_dat}
\alias{cfp_layers_map.data.frame}
\title{Model layers}
\usage{
cfp_layers_map(x, ...)

\method{cfp_layers_map}{cfp_dat}(x, ...)

\method{cfp_layers_map}{data.frame}(
  x,
  id_cols,
  gas = NULL,
  lowlim = NULL,
  highlim = NULL,
  layer_couple = 0,
  ...
)
}
\arguments{
\item{x}{(data.frame) That defines the layers for which the
production or flux is modeled. Note that some parameters can also be provided
directly to the function call instead (see Details).
\itemize{
\item \code{id_cols} the relevant id_cols (see below)
\item \code{gas}, the gas that is modelled.
\item \code{upper}, \code{lower} the upper and lower boundaries
of each layer
\item \code{lowlim}, \code{highlim} as the lower and upper limits of the
production rate to be modeled in \eqn{\mu~mol~m^{-3}}
\item the parameter \code{layer_couple}, that indicates how
strongly the layer should be linked to the one below it (0 for no coupling)
}}

\item{...}{not used}

\item{id_cols}{Column names in data.frame that uniquely identify each
profile.}

\item{gas}{(character vector) of gas names to be added to
x which is then repeated for each gas.}

\item{lowlim}{(numeric vector) the same length as \code{gas} with the
lower limit of possible production allowed in \code{\link[=pro_flux]{pro_flux()}} models.}

\item{highlim}{(numeric vector)  the same length as gas with the
upper limit of possible production allowed in \code{\link[=pro_flux]{pro_flux()}} models.}

\item{layer_couple}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} (numeric_vector)
A vector the same length as gas that indicates how strongly the layer should
be linked to the one below it (0 for no coupling, the default).}
}
\value{
A \code{\link[=cfp_layered_profile]{cfp_layered_profile()}} \code{data.frame} with the columns
described above as well as \code{layer} and \code{pmap} columns that identify
each layer with an integer (ascending from bottom to top).
}
\description{
A function to create a cfp_layers_map object that defines the
layers of both \code{\link[=fg_flux]{fg_flux()}} and \code{\link[=pro_flux]{pro_flux()}} models.
}
\section{Add lowlim and highlim for multiple gases}{
Sometimes it is practical to model different gases with different limits.
For example, it is a reasonable assumption that CO2 is not consumed in
relevant amounts in most soils, whereas CH4 may be both produced or consumed.
Therefore we may want to limit production rates of CO2 to only positive
values, whereas allowing for negative CH4 production rates (i.e. consumption)
as well.

To make this setup easy, you can provide a \code{gas} vector to the function
together with \code{highlim} and \code{lowlim} vectors of the same length.
The provided \code{layers_map} \code{data.frame} will then be replicated for
each gas with the respective values of the production limits provided.
}

\examples{
cfp_layers_map(
   ConFluxPro::layers_map,
   gas = "CO2",
   lowlim = 0,
   highlim = 1000,
   id_cols = "site")

### add multiple gases at once
cfp_layers_map(
   ConFluxPro::layers_map,
   id_cols = "site",
   gas = c("CO2", "CH4"),
   lowlim = c(0, -1000),
   highlim = c(1000, 1000))

### Extract from an existing cfp_dat
cfp_layers_map(ConFluxPro::base_dat)
}
\seealso{
Other data formats: 
\code{\link{cfp_dat}()},
\code{\link{cfp_gasdata}()},
\code{\link{cfp_layered_profile}()},
\code{\link{cfp_profile}()},
\code{\link{cfp_soilphys}()}
}
\concept{data formats}
