test_that("xposeNlme works with ConvergenceData ", {
  workingDir <- system.file("extdata/combined_gof",
    package = "Certara.Xpose.NLME",
    mustWork = TRUE
  )
  modelName <- "test1"
  dmp.json <- paste0(modelName, "_dmp.json")
  dmp.txt <- jsonlite::fromJSON(readLines(file.path(workingDir, dmp.json)))

  residuals.csv <- paste0(modelName, "_residuals.csv")
  dmp.txt$residuals <- utils::read.csv(file.path(workingDir, residuals.csv))

  dataFile <- paste0("pkData.csv")

  logFile <- paste0(modelName, "_nlme7engine.log")

  ConvergenceDatacsv <- file.path(workingDir, paste0(modelName, "_ConvergenceData.csv"))
  ConvergenceData <- utils::read.csv(ConvergenceDatacsv)

  xpdb <- xposeNlme(
    dir = workingDir,
    dmp.txt = dmp.txt,
    dataFile = dataFile,
    logFile = logFile,
    ConvergenceData = ConvergenceData
  )

  testthat::local_edition(3)
  testthat::expect_snapshot(tail(as.data.frame(xpdb$files$data[[1]])))
  testthat::expect_snapshot(tail(as.data.frame(xpdb$data$data[[1]])))
})
