% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valProbSurvival.R
\name{valProbSurvival}
\alias{valProbSurvival}
\title{Plot a calibration curve for a Cox Proportional Hazards model}
\usage{
valProbSurvival(
  fit,
  valdata,
  alpha = 0.05,
  timeHorizon = 5,
  nk = 3,
  plotCal = c("none", "base", "ggplot"),
  addCox = FALSE,
  addRCS = TRUE,
  CL.cox = c("fill", "line"),
  CL.rcs = c("fill", "line"),
  xlab = "Predicted probability",
  ylab = "Observed proportion",
  xlim = c(-0.02, 1),
  ylim = c(-0.15, 1),
  lty.ideal = 1,
  col.ideal = "red",
  lwd.ideal = 1,
  lty.cox = 1,
  col.cox = "grey",
  lwd.cox = 1,
  fill.cox = "lightgrey",
  lty.rcs = 1,
  col.rcs = "black",
  lwd.rcs = 1,
  fill.rcs = rgb(177, 177, 177, 177, maxColorValue = 255),
  riskdist = "predicted",
  d0lab = "0",
  d1lab = "1",
  size.d01 = 5,
  dist.label = 0.01,
  line.bins = -0.05,
  dist.label2 = 0.04,
  length.seg = 0.85,
  legendloc = c(0.5, 0.27)
)
}
\arguments{
\item{fit}{the model fit, has to be of type \code{\link[survival]{coxph}}}

\item{valdata}{the validation data set}

\item{alpha}{the significance level}

\item{timeHorizon}{the time point at which the predictions have to be evaluated}

\item{nk}{the number of knots, for the restricted cubic splines fit}

\item{plotCal}{indicates if and how the calibration curve has to be plotted.
\code{plotCal = "none"} plots no calibration curve, \code{plotCal = "base"} plots
the calibration curve using base R (see \code{\link{plot}}) and \code{plotCal = "ggplot"}
creates a plot using \code{\link[ggplot2]{ggplot}}}

\item{addCox}{logical, indicates if the Cox's estimated calibration curve has to be added
to the plot}

\item{addRCS}{logical, indicates if the restricted cubic splines' (RCS) estimated calibration curve has to be added
to the plot}

\item{CL.cox}{\code{"fill"} shows pointwise 95\% confidence limits for the Cox calibration curve with a gray
area between the lower and upper limits and \code{"line"} shows the confidence limits with a dotted line}

\item{CL.rcs}{\code{"fill"} shows pointwise 95\% confidence limits for the RCS calibration curve with a gray
area between the lower and upper limits and \code{"line"} shows the confidence limits with a dotted line}

\item{xlab}{x-axis label, default is \code{"Predicted Probability"}.}

\item{ylab}{y-axis label, default is \code{"Observed proportion"}.}

\item{xlim, ylim}{numeric vectors of length 2, giving the x and y coordinates ranges (see \code{\link{plot.window}})}

\item{lty.ideal}{linetype of the ideal line. Default is \code{1}.}

\item{col.ideal}{controls the color of the ideal line on the plot. Default is \code{"red"}.}

\item{lwd.ideal}{controls the line width of the ideal line on the plot. Default is \code{1}.}

\item{lty.cox}{if \code{addCox = TRUE}, the linetype of the Cox calibration curve}

\item{col.cox}{if \code{addCox = TRUE}, the color of the Cox calibration curve}

\item{lwd.cox}{if \code{addCox = TRUE}, the linewidth of the Cox calibration curve}

\item{fill.cox}{if \code{addCox = TRUE} and \code{CL.cox = "fill"}, the fill of the Cox calibration curve}

\item{lty.rcs}{if \code{addRCS = TRUE}, the linetype of the RCS calibration curve}

\item{col.rcs}{if \code{addRCS = TRUE}, the color of the RCS calibration curve}

\item{lwd.rcs}{if \code{addRCS = TRUE}, the linewidth of the RCS calibration curve}

\item{fill.rcs}{if \code{addRCS = TRUE} and \code{CL.rcs = "fill"}, the fill of the RCS calibration curve}

\item{riskdist}{
Use \code{"calibrated"} to plot the relative frequency distribution of
calibrated probabilities after dividing into 101 bins from \code{lim[1]} to
\code{lim[2]}.
Set to \code{"predicted"} (the default as of rms 4.5-1) to use raw assigned risk, \code{FALSE} to omit risk distribution.
Values are scaled so that highest bar is \code{0.15*(lim[2]-lim[1])}.
}

\item{d0lab, d1lab}{controls the labels for events and non-events (i.e. outcome y) for the histograms.
Defaults are \code{d1lab="1"} for events and \code{d0lab="0"} for non-events.}

\item{size.d01}{controls the size of the labels for events and non-events. Default is 5 and
this value is multiplied by 0.25 when \code{plotCal = "base"}.}

\item{dist.label}{controls the horizontal position of the labels for events and non-events. Default is 0.04.}

\item{line.bins}{controls the horizontal (y-axis) position of the histograms. Default is -0.05.}

\item{dist.label2}{controls the vertical distance between the labels for events and non-events. Default is 0.03.}

\item{length.seg}{controls the length of the histogram lines. Default is \code{1}.}

\item{legendloc}{if \code{pl=TRUE}, list with components \code{x,y} or vector \code{c(x,y)} for bottom right corner of legend for
curves and points. Default is \code{c(.50, .27)} scaled to lim. Use \code{locator(1)} to use the mouse, \code{FALSE} to suppress legend.}
}
\value{
An object of type \code{SurvivalCalibrationCurves} with the following slots:

\item{call}{the matched call.}

\item{stats}{a list containing performance measures of calibration.}

\item{alpha}{the significance level used.}

\item{Calibration}{contains the estimated calibration slope, together with their confidence intervals.}

\item{CalibrationCurves}{The coordinates for plotting the calibration curves. }
}
\description{
Plot a calibration curve for a Cox Proportional Hazards model
}
\examples{
\dontrun{
library(CalibrationCurves)
library(survival)
data(trainDataSurvival)
data(testDataSurvival)
sFit = coxph(Surv(ryear, rfs) ~ csize + cnode + grade3, data = trainDataSurvival,
 x = TRUE, y = TRUE)
calPerf = valProbSurvival(sFit, testDataSurvival, plotCal = "base", nk = 5)
}
}
\references{
van Geloven N, Giardiello D, Bonneville E F, Teece L, Ramspek C L, van Smeden M et al. (2022). Validation of prediction models in the presence of competing risks: a guide through modern methods. \emph{BMJ}, \bold{377:e069249}, doi:10.1136/bmj-2021-069249
}
