% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Log_Normal_Log_Normal_Formula.R
\name{Log_Normal_Log_Normal_Formula}
\alias{Log_Normal_Log_Normal_Formula}
\title{Log-Normal Log-Normal (double curve) CDF Equation Formula}
\usage{
Log_Normal_Log_Normal_Formula(
  concentration,
  shape_location,
  scale,
  shape_location_2,
  scale_2,
  weight
)
}
\arguments{
\item{concentration}{The vector of concentration values for a selected pesticide,
that has a Log Normal Log Normal species sensitivity distribution,
to run the equation on.}

\item{shape_location}{The mu/shape value for the first Log Normal equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{scale}{The sigma/scale value for the first Log Normal equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{shape_location_2}{The mu/shape value for the second Log Normal equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{scale_2}{The sigma/scale value for the second Log Normal equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{weight}{The weight parameter for combining the two equations for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}
}
\value{
a numeric vector
}
\description{
Log-Normal Log-Normal (double curve) CDF Equation Formula
}
\examples{
#This Example should produce roughly 1\% and 5\% PRM values
LogN_LogN_pesticide_concentrations <- c(4.79E-05, 0.000225588)
Log_Normal_Log_Normal_Formula(concentration = LogN_LogN_pesticide_concentrations,
shape_location = -5.596431, scale = 2.061943,
shape_location_2 = 0.01174954, scale_2 = 0.9134796, weight = 0.5733126)
}
