#' Title
#'
#' @param Prob A vector of probability predictions provided by the predicted model
#' @param yt  A vector 0/1 with the dichotomic outcome values
#' @param z The rate of missclassified events
#'
#' @return The value of the efficacy of the marker
#' @export
#'
#' @examples
#'Prob<-c(rnorm(10000,0.4,0.1),rnorm(10000,0.5,0.05))
#'yt<-rep(c(0,1),c(10000,10000))
#'Efficacy (Prob,yt,10)


Efficacy<-function(Prob,yt,z){
  x<-seq(0,100,by=0.01)
  MC<-function(x){sum(yt[Prob*100<x],na.rm=T)/sum(yt)*100}
  SB<-function(x){length(yt[Prob*100<x]&!is.na(yt[Prob*100<x]))/length(yt)*100}

  inverse = function (MC, lower = 0.01, upper = 100) {
    function (y) uniroot((function (x) MC(x) - y), lower = lower, upper = upper)[1]

  }
  MC_inverse = inverse(sum(yt[Prob*100<x],na.rm=T)/sum(yt)*100, 0, 100)
  ST<-function(z){
    suppressWarnings(SB(MC_inverse(z)$root))-z}

  abs(ST(z))
}

