% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSeQTL.R
\name{OLS_sim}
\alias{OLS_sim}
\title{OLS_sim}
\usage{
OLS_sim(
  NN,
  MAF,
  true_BETA0,
  true_KAPPA,
  true_ETA,
  wRHO,
  RR,
  trim = FALSE,
  thres_TRIM = 10,
  showRHO = TRUE
)
}
\arguments{
\item{NN}{Positive integer for sample size.}

\item{MAF}{Positive numeric value between 0 and 1 for the minor 
allele frequency to simulate phased SNP genotypes assuming Hardy-Weinberg.}

\item{true_BETA0}{A positive numeric value denoting the reference cell type
and reference base's expression multiplied by two and log transformed.
For example, if the TReC for reference base and cell type is 500, then
\code{true_BETA0 = log{2 * 500}}.}

\item{true_KAPPA}{A numeric vector denoting the baseline fold change in TReC
between a cell type and reference. By definition, the first element is 1.}

\item{true_ETA}{A numeric vector where each element denotes the fold change 
in TReC between the non-reference and reference base in a cell type.}

\item{wRHO}{Takes integer values 1, 2, or 3 to simulate three 
scenarios of cell type proportions.}

\item{RR}{A positive integer for number of replicates to generate and analyze.}

\item{trim}{Boolean value set to \code{FALSE} by default to prevent
outcome trimming. If \code{TRUE}, the OLS model will be fitted
without covariates containing SNP genotype to calculate each 
subject's Cooks' distance.}

\item{thres_TRIM}{A positive numeric value to perform subject outcome trimming.
Subjects with standardized Cooks' Distances greater than the threshold are trimmed.}

\item{showRHO}{Boolean for seeing a preview of how 
proportions are distributed.}
}
\value{
Simulation results for OLS-based approach with per replicate
and per cell type metrics including p-values, OLS effect sizes,
and proportion of samples with trimmed outcomes.
}
\description{
OLS_sim
}
